<?php
session_start();
include 'conexao.php'; // conexão com o banco

if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

$usuarioId = $_SESSION['usuario']; // ou $_SESSION['usuario']['id'] se for um array

if (isset($_FILES['foto']) && $_FILES['foto']['error'] === 0) {
    $pasta = "fotos/";
    $extensao = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
    $nomeFoto = uniqid('foto_') . "." . strtolower($extensao);

    // Cria pasta se não existir
    if (!is_dir($pasta)) {
        mkdir($pasta, 0777, true);
    }

    // Move o arquivo
    if (move_uploaded_file($_FILES['foto']['tmp_name'], $pasta . $nomeFoto)) {
        // Atualiza no banco
        $stmt = $conn->prepare("UPDATE usuarios SET foto = ? WHERE id = ?");
        $stmt->bind_param("si", $nomeFoto, $usuarioId);
        $stmt->execute();

        // Atualiza sessão
        $_SESSION['foto'] = $nomeFoto;
    }
}

// Redireciona de volta ao painel
header("Location: painel.php");
exit;
